
#|________________________________________________________________________
 |
 | Correspondence Analysis plugin loading function
 |________________________________________________________________________
 |#


(setf *crs-plugin-path* (strcat *plugin-path* "crsplug" *separator*))
(let ((menu-item-title "Correspondence Analysis")
      (tool-name "Coresp")
      (model-prefix "CRS")
      (ok-data-types '("freq"))
      (ok-variable-types '(numeric)))

  (send *vista* :install-plugin tool-name menu-item-title ok-data-types)

(defun correspondence-analysis (&rest args)
"ViSta plugin function to perform Correspondence Analysis.  
With no arguments, performs a 3-dimensional, row and column normalized correspondence analysis of the active variables in the current data, results being printed to a precision of 4 decimal places. 
Keyword arguments are
:DIMENSIONS followed by an integer to specify the dimensionality of the analysis (default is 3);
:PROFILE followed by one of the following character strings: 
         BOTH (default) to analyze both row and column profiles,
         ROW to analyze row profiles,
         COLUMN to analyze column profiles;
:PRECISION followed by an integer specifying the number of printed decimals;
:DATA followed by the name of the data to be analyzed (default: current-data);
:TITLE followed by a character string (default: Correspondence Analysis);
:DIALOG followed by t (to display parameters dialog box) or nil (default)."
  (format t "; CopyRt: CORESP Copyright (c) 1992-2002, by Lee Bee Leng & Forrest W. Young~%> ")
  (load (strcat *crs-plugin-path* "crspmob1"))
  (apply #'correspondence-analysis args))
  )
